<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
package ${pub.getPKGCodeName()}.api.swagger;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.google.common.base.Predicates.or;
import static springfox.documentation.builders.PathSelectors.regex;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration {

    @Bean
    public Docket docket() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("DEFAULT")
                .pathMapping("/")
                .apiInfo(
						new ApiInfoBuilder()
						.title("DEFAULT")
						.build()
                    )
                .select()
                .paths(or(regex("/rest/.*")))
                .build()
                ;
    }

    <#if sys.getAllPSSysServiceAPIs()??>
        <#list sys.getAllPSSysServiceAPIs() as api>
	@Bean
	public Docket ${api.getCodeName()?lower_case}Docket() {
		return new Docket(DocumentationType.SWAGGER_2)
				.groupName("${api.getName()}")
				.pathMapping("/")
				.apiInfo(
						new ApiInfoBuilder()
						.title("${api.getName()}")
						.version("${api.getAPIVersion()}")
						.build()
                    )
				.select()
				.paths(or(regex("/rest/${api.getCodeName()?lower_case}/.*")))
				.build()
				;
	}
        </#list>
    </#if>

}
